/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.ftb.ftbsbc.dimensions.DimensionsClient;
import dev.ftb.ftbsbc.dimensions.DimensionsManager;
import dev.ftb.ftbsbc.dimensions.arguments.DimensionCommandArgument;
import dev.ftb.ftbsbc.dimensions.arguments.PrebuiltCommandArgument;
import dev.ftb.ftbsbc.dimensions.kubejs.StoneBlockDataKjs;
import dev.ftb.ftbsbc.dimensions.level.ArchivedDimension;
import dev.ftb.ftbsbc.dimensions.level.DimensionStorage;
import dev.ftb.ftbsbc.dimensions.level.DynamicDimensionManager;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.EmptyArgumentSerializer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBStoneBlockCommands {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final LevelResource EXPORT_PATH = new LevelResource("stoneblock-export.png");
    public static final DynamicCommandExceptionType NOT_PARTY_TEAM = new DynamicCommandExceptionType(object -> new TextComponent("[%s] is not a party team...".formatted(object)));
    public static final DynamicCommandExceptionType DIM_MISSING = new DynamicCommandExceptionType(object -> new TextComponent("[%s] can not be found".formatted(object)));
    public static final DynamicCommandExceptionType NO_DIM = new DynamicCommandExceptionType(object -> new TextComponent("No dimension found for %s".formatted(object)));

    public static void setup() {
        ArgumentTypes.m_121601_((String)"ftbsbc:prebuilt", PrebuiltCommandArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(PrebuiltCommandArgument::create));
        ArgumentTypes.m_121601_((String)"ftbsbc:archived", DimensionCommandArgument.class, (ArgumentSerializer)new EmptyArgumentSerializer(DimensionCommandArgument::create));
    }

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LOGGER.info("Registering StoneBlock Commands");
        LiteralCommandNode commands = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sbc").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reload-and-export-biomes").requires(source -> source.m_6761_(2) && source.m_81377_().m_129792_())).executes(context -> FTBStoneBlockCommands.exportBiomes((CommandSourceStack)context.getSource(), StoneBlockDataKjs.getDefaultMaxDistance()))).then(Commands.m_82129_((String)"max-distance", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20000)).executes(context -> FTBStoneBlockCommands.exportBiomes((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"max-distance")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"visit").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create()).executes(context -> FTBStoneBlockCommands.visitDim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list-archived").requires(source -> source.m_6761_(2))).executes(context -> FTBStoneBlockCommands.listArchived((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"prune-all").requires(source -> source.m_6761_(2))).executes(context -> FTBStoneBlockCommands.prune((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"prune").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionCommandArgument.create()).executes(context -> FTBStoneBlockCommands.prune((CommandSourceStack)context.getSource(), DimensionCommandArgument.get((CommandContext<CommandSourceStack>)context, "dimension")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"restore").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionCommandArgument.create()).executes(context -> FTBStoneBlockCommands.restore((CommandSourceStack)context.getSource(), DimensionCommandArgument.get((CommandContext<CommandSourceStack>)context, "dimension"), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))))).then(Commands.m_82127_((String)"lobby").executes(context -> FTBStoneBlockCommands.lobby((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"home").executes(context -> FTBStoneBlockCommands.home((CommandSourceStack)context.getSource()))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbstoneblock").redirect((CommandNode)commands));
    }

    private static int restore(CommandSourceStack source, ArchivedDimension dimension, ServerPlayer player) throws CommandSyntaxException {
        PartyTeam party = (PartyTeam)FTBTeamsAPI.getManager().createParty(player, player.m_7755_().getString() + " Party").getValue();
        ResourceKey<Level> levelResourceKey = DimensionStorage.get(source.m_81377_()).putDimension((Team)party, dimension.dimensionName());
        DimensionStorage.get(source.m_81377_()).getArchivedDimensions().remove(dimension);
        DimensionStorage.get(source.m_81377_()).m_77762_();
        DynamicDimensionManager.teleport(player, levelResourceKey);
        source.m_81354_((Component)new TextComponent("Successfully restored dimension").m_130940_(ChatFormatting.GREEN), false);
        return 0;
    }

    private static int prune(CommandSourceStack source, ArchivedDimension dimension) throws CommandSyntaxException {
        List<ArchivedDimension> archivedDimensions = DimensionStorage.get(source.m_81377_()).getArchivedDimensions();
        if (!archivedDimensions.contains(dimension)) {
            throw DIM_MISSING.create((Object)dimension.dimensionName());
        }
        DynamicDimensionManager.destroy(source.m_81377_(), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimension.dimensionName()));
        archivedDimensions.remove(dimension);
        DimensionStorage.get(source.m_81377_()).m_77762_();
        source.m_81354_((Component)new TextComponent("Successfully pruned %s".formatted(dimension.dimensionName())).m_130940_(ChatFormatting.GREEN), false);
        return 0;
    }

    private static int prune(CommandSourceStack source) {
        MinecraftServer server = source.m_81377_();
        List<ArchivedDimension> archivedDimensions = DimensionStorage.get(source.m_81377_()).getArchivedDimensions();
        int size = archivedDimensions.size();
        for (ArchivedDimension e : archivedDimensions) {
            DynamicDimensionManager.destroy(server, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)e.dimensionName()));
        }
        DimensionStorage.get(source.m_81377_()).getArchivedDimensions().clear();
        DimensionStorage.get(source.m_81377_()).m_77762_();
        source.m_81354_((Component)new TextComponent("Successfully pruned %s dimensions".formatted(size)).m_130940_(ChatFormatting.GREEN), false);
        return 0;
    }

    private static int listArchived(CommandSourceStack source) {
        List<ArchivedDimension> archivedDimensions = DimensionStorage.get(source.m_81377_()).getArchivedDimensions();
        if (archivedDimensions.isEmpty()) {
            source.m_81352_((Component)new TextComponent("No archived dimensions available"));
            return -1;
        }
        for (ArchivedDimension archivedDimension : archivedDimensions) {
            source.m_81354_((Component)new TextComponent("%s: [team=%s] [owner=%s]".formatted(archivedDimension.dimensionName(), archivedDimension.teamName(), archivedDimension.teamOwner())), false);
        }
        return 0;
    }

    private static int visitDim(CommandSourceStack source, Team team) throws CommandSyntaxException {
        if (team.getType() != TeamType.PARTY) {
            throw NOT_PARTY_TEAM.create((Object)team.getName().getString());
        }
        ResourceKey<Level> dimension = DimensionsManager.INSTANCE.getDimension(team);
        if (dimension == null) {
            throw NO_DIM.create((Object)team.getName().getString());
        }
        DynamicDimensionManager.teleport(source.m_81375_(), dimension);
        return 0;
    }

    private static int lobby(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        if (DynamicDimensionManager.teleport(player, (ResourceKey<Level>)Level.f_46428_)) {
            return 1;
        }
        return 0;
    }

    private static int home(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        Team team = FTBTeamsAPI.getPlayerTeam((ServerPlayer)player);
        if (team.getType().isParty() && DynamicDimensionManager.teleport(player, DimensionsManager.INSTANCE.getDimension((Player)player))) {
            return 1;
        }
        source.m_81352_((Component)new TextComponent("Go to the lobby and jump through the portal!"));
        return 0;
    }

    private static int exportBiomes(CommandSourceStack source, int radius) {
        if (radius <= 0) {
            source.m_81352_((Component)new TextComponent("Empty image!"));
            return 0;
        }
        source.m_81354_((Component)new TextComponent("Exporting " + (radius * 2 + 1) + "x" + (radius * 2 + 1) + " image..."), false);
        DimensionsClient.exportBiomes(source.m_81372_(), source.m_81377_().m_129843_(EXPORT_PATH), radius);
        source.m_81354_((Component)new TextComponent("Done!"), false);
        return 1;
    }
}

